	function PLOT_TG_Z(wT, Taug, axis_Tg_min, axis_Tg_max)
 
	% 	Plots the group delay for a digital filter
 
	%	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% 	Author: 		Lars Wanhammar 2005-05-08
	% 	Modified by: 	LW 2010-11-25
	% 	Copyright:		by authors - not released for commercial use
	% 	Version:		
	% 	Known bugs:	 
	% 	Report bugs to:	Wanhammar@gmail.com
 
	%========================================================	
	% Standard settings
	fs = 16; 		% Font size
	lw = 2; 		% Linewidth
	fn = 'times'; 	% Font
	%========================================================	
	if nargin < 3
		axis_Tg_max = ceil(max(Taug)*1.2);
	end
	hold on;
  	
	axis([0 max(wT) axis_Tg_min axis_Tg_max]); %  This may be changed to get a neater plot
 	plot(wT, Taug,'linewidth', lw) 
	ylabel('{\it\tau_g}({\ite^j^\omega^T}) [rad]','FontName', fn,'FontSize',fs);
	xlabel('{\it\omegaT} [rad]','FontName', fn,'FontSize', fs);
	set(gca,'FontName', fn,'FontSize', fs);
	
	if max(wT) < 0.15*pi
		ax = [0 0.03*pi 0.06*pi 0.09*pi 0.12*pi];
		lab = {'0';'0.03\pi';'0.06\pi';'0.09\pi';'0.12\pi'};
		xtick(ax,lab);
		xlabel('{\it\omegaT}  [rad]','FontName', 'times','FontSize',16);
		ylabel('{\it\tau_g}({\ite^j^\omega^T }) [T]','FontName',  'times','FontSize',16);
		grid on
	 
	else
		ax = [0 0.1*pi 0.2*pi  0.3*pi  0.4*pi 0.5*pi 0.6*pi 0.7*pi 0.8*pi 0.9*pi pi];	
		lab = {'0';'0.1\pi';'0.2\pi';'0.3\pi';'0.4\pi';'0.5\pi';'0.6\pi';'0.7\pi';'0.8\pi';'0.9\pi';'\pi'};
	end
	xtick(ax,lab);
	box on;
	grid on;
	
	
	
